% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar_time.R
\name{calendar_time}
\alias{calendar_time}
\title{Calculate Calendar Times for Interim Analysis Looks}
\usage{
calendar_time(
  k,
  d2max,
  htime,
  hevent,
  delta,
  ta,
  tf,
  method = c("KM"),
  event_ind = 1
)
}
\arguments{
\item{k}{Numeric vector of event fractions for each look (e.g., c(0.5, 1))}

\item{d2max}{maximum number of events in the experimental group calculated from the design function.}

\item{htime}{Historical survival times}

\item{hevent}{Historical event indicators (0/1)}

\item{delta}{Hazard ratio (experimental vs. historical)}

\item{ta}{Accrual time}

\item{tf}{Follow-up time}

\item{method}{"exponential", "log_normal" or "KM" for survival function estimation(Default is KM)}

\item{event_ind}{Event indicator value (default = 1)}
}
\value{
Data frame with columns: Distribution, look, time fraction, events, calendar time
}
\description{
Calculate Calendar Times for Interim Analysis Looks
}
\examples{
time <- c(20, 65, 12, 50, 58, 65, 45, 44)
event <- c(1, 0, 0, 0, 1, 1, 1, 1)
gg<-calendar_time(k=c(0.5, 1),d2max=46,htime=time,hevent=event,delta=0.7,ta=5,tf=4,method="KM")
}
\references{
\insertRef{doi:10.1002/pst.1756}{HCTDesign}

\insertRef{doi:10.1080/10543406.2019.1684305}{HCTDesign}
}
\author{
Tushar Patni, Yimei Li and Jianrong Wu.
}
