% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_uni.R
\name{UNP}
\alias{UNP}
\title{UNP scan procedure}
\usage{
UNP(data, MC = 999, typeI = 0.05, initialization, permutations)
}
\arguments{
\item{data}{vector. Vector of the data, each element corresponds to a site (or an individual if the observations are by individuals and not by sites).}

\item{MC}{numeric. Number of Monte-Carlo permutations to evaluate the statistical significance of the clusters. By default: 999.}

\item{typeI}{numeric. The desired type I error. A cluster will be evaluated as significant if its associated p-value is less than typeI. By default 0.05.}

\item{initialization}{list. Initialization for the scan procedure (see \code{\link{InitScan}} for more details).}

\item{permutations}{matrix. Indices of permutations of the data.}
}
\value{
An object of class ResScanOutputUni.
}
\description{
This function computes the UNP (Univariate Nonparametric scan statistic).
}
\references{
Inkyung Jung and Ho Jin Cho (2015). A Nonparametric Spatial Scan Statistic for Continuous Data. International Journal of Health Geographics, 14.
}
