% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_umap.R
\name{plot_umap}
\alias{plot_umap}
\title{Diagnostic UMAP plots showing the partitioning of cells into responding and non-responding groups by HDStIM}
\usage{
plot_umap(mapped_data, path = NULL, verbose = FALSE)
}
\arguments{
\item{mapped_data}{Returned list from the \code{\link{HDStIM}} function.}

\item{path}{Path to the folder to save figures generated by this function.}

\item{verbose}{Logical. To make function more verbose. Default is FALSE.}
}
\value{
A list of ggplot objects. If the path is not NULL, PNG files of the plots are saved in the specified folder.
}
\description{
Diagnostic UMAP plots showing the partitioning of cells into responding and non-responding groups by HDStIM
}
\examples{
\donttest{
mapped_data <- HDStIM(chi11$expr_data, chi11$state_markers,
                      chi11$cluster_col, chi11$stim_label,
                      chi11$unstim_label, seed_val = 123, umap = TRUE, 
                      umap_cells = 50, verbose = FALSE)

pu <- plot_umap(mapped_data, path = NULL, verbose = FALSE)
}
}
