% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_dataset.R
\name{prepare_dataset}
\alias{prepare_dataset}
\title{Calculate data}
\usage{
prepare_dataset(
  dat,
  in_state_first,
  chosen_state_first,
  out_state_first,
  in_state_second,
  chosen_state_second,
  out_state_second
)
}
\arguments{
\item{dat}{data frame with data from DynamX file}

\item{in_state_first}{string in form "state_time" for first state in in time}

\item{chosen_state_first}{string in form "state_time" for chosen state in in time}

\item{out_state_first}{string in form "state_time" for first state in out time}

\item{in_state_second}{string in form "state_time" for second state in in time}

\item{chosen_state_second}{string in form "state_time" for second state in chosen time}

\item{out_state_second}{string in form "state_time" for second state in out time}
}
\value{
data frame with calculated values
}
\description{
Calculates values for visualization  from input data file - both experimental and theoretical. All parameters are needed.
}
\details{
...

This is the first version - multi-state calculations are not supported.
}
\examples{
# load example data
dat <- read_hdx(system.file(package = "HaDeX", "HaDeX/data/KD_180110_CD160_HVEM.csv"))

# prepare dataset for states `CD160` and `CD160_HVEM` in given time parameters
prepare_dataset(dat,
                in_state_first = "CD160_0.001",
                chosen_state_first = "CD160_1",
                out_state_first = "CD160_1440",
                in_state_second = "CD160_HVEM_0.001",
                chosen_state_second = "CD160_HVEM_1",
                out_state_second = "CD160_HVEM_1440") 

}
\seealso{
\code{\link{read_hdx}}
}
