% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hadamard_matrix.R
\name{Hadamard_Matrix}
\alias{Hadamard_Matrix}
\title{Hadamard_Matrix}
\usage{
Hadamard_Matrix(order)
}
\arguments{
\item{order}{integer}
}
\value{
Hadamard Matrix of given Order
}
\description{
Hadamard_Matrix is generic function for construction of Hadamard matrix.
}
\details{
function Hadamard_matrix was created which does not require known of
construction methods. Hadamard_matrix() takes an integer as input and returns
Hadamard matrix if it is available. In case, it is not possible to construct,
NULL value is returned.
}
\examples{
Hadamard_Matrix(1)
#1
Hadamard_Matrix(2)
#      [,1] [,2]
# [1,]    1    1
# [2,]    1   -1
Hadamard_Matrix(8)
      # [,1] [,2] [,3] [,4] [,5] [,6] [,7] [,8]
# [1,]    1    1    1    1    1    1    1    1
# [2,]    1   -1    1   -1    1   -1    1   -1
# [3,]    1    1   -1   -1    1    1   -1   -1
# [4,]    1   -1   -1    1    1   -1   -1    1
# [5,]    1    1    1    1   -1   -1   -1   -1
# [6,]    1   -1    1   -1   -1    1   -1    1
# [7,]    1    1   -1   -1   -1   -1    1    1
# [8,]    1   -1   -1    1   -1    1    1   -1
Hadamard_Matrix(10)
#"Order is not a Hadamard number"
Hadamard_Matrix(668)
#"Not possible to construct or order is not a multiple of 4"
}
