#' Hapi is a novel easy-to-use package that only requires 3 to 5 gametes 
#' to reconstruct accurate and high-resolution haplotypes of an individual. 
#' The gamete genotype data may be generated from various platforms including 
#' genotyping arrays and next generation sequencing even with low-coverage. 
#' Hapi simply takes genotype data of known hetSNPs in single gamete cells 
#' as input and report the high-resolution haplotypes as well as confidence 
#' level of each phased hetSNPs. The package also includes a module allowing 
#' downstream analyses and visualization of crossovers in the gametes.
#'
#' @name Hapi-package
#' @aliases Hapi-package Hapi
#' @docType package
NULL



#' Raw genotyping data
#' @name gmt
#' @docType data
#' @keywords datasets
NULL


#' Chromosome information of hg19
#' @name hg19
#' @docType data
#' @keywords datasets
NULL


#' Haplotypes of a single gamete cell for visualization
#' @name gamete11
#' @docType data
#' @keywords datasets
NULL


#' Crossover information across all gamete cells
#' @name crossover
#' @docType data
#' @keywords datasets
NULL