% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{base2num}
\alias{base2num}
\title{Convert genotype coded in A/T/C/G to 0/1}
\usage{
base2num(gmt, ref, alt)
}
\arguments{
\item{gmt}{a dataframe of genotype data of gamete cells}

\item{ref}{a character represents reference allele}

\item{alt}{a character represents alternative allele}
}
\value{
a dataframe containing converted genotype
}
\description{
Convert base (A/T/C/G) coded genotype to numeric (0/1) coded
}
\examples{
ref <- sample(c('A','T'),500, replace=TRUE)
alt <- sample(c('C','G'),500, replace=TRUE)

gmt <- data.frame(chr=rep(1,500), pos=seq_len(500),
    ref=ref, alt=alt, gmt1=ref, gmt2=alt, gmt3=ref,
    gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
    stringsAsFactors = FALSE)
    
gmtDa <- base2num(gmt=gmt[5:9], ref=ref, alt=alt)
}
\author{
Ruidong Li
}
