% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_locus_perm_cv.R
\name{plot_locus_perm_cv}
\alias{plot_locus_perm_cv}
\title{Visualize Permutation CV Results}
\usage{
plot_locus_perm_cv(results, individual_images = FALSE)
}
\arguments{
\item{results}{An object of class "list" which is derived from the "locus_perm_cv" function.}

\item{individual_images}{A logical argument that defines if the user wants both the composite image and the full image. Default setting is FALSE.}
}
\value{
Prints a ggplot2 image
}
\description{
This function takes a list of list object from the "locus_perm_cv" function and creates a summary graphic of the accuracy, kappa, sensitivity, and specificity of the models ran. If heterozygous individuals were left in the cross validation scheme, by-class sensitivity and specificity will be displayed; otherwise, displayed parameters will be of the overall model.
}
\examples{

#refer to vignette for an in depth look at the plot_locus_perm_cv function
vignette("An_Intro_to_HaploCatcher", package = "HaploCatcher")

}
