% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories.R
\name{distmat}
\alias{distmat}
\title{Calculate scSLAM-seq based distance matrices}
\usage{
distmat(prev.t, next.t, prevAssay, nextAssay, gene_subset = NULL)
}
\arguments{
\item{prev.t}{Cells to be used from the previous time point in distance matrix calculation.}

\item{next.t}{Cells to be used from the next time point in distance matrix calculation.}

\item{prevAssay}{Name of the expression assay of cells from the previous time point.}

\item{nextAssay}{Name of the expression assay of cells from the next time point.}

\item{gene_subset}{Set a subset of genes on which trajectories should be calculated. Other genes will be disregarded.}
}
\value{
Distance matrix between cells from two time points.
}
\description{
This function calculates distances matrices between cells of different time points based on metabolic labeling RNA profiles.
}
\examples{
\donttest{

# Full vignette available on https://grandr.erhard-lab.de/articles/web/hetseq.html

  obj.list <- SplitObject(seuratObject, split.by = "time")
  D.list=list(
   distmat(treatment.list[["0h"]],treatment.list[["2h"]], "RNA", "prevRNA"),
   distmat(treatment.list[["2h"]],treatment.list[["4h"]], "RNA", "prevRNA")
  )
}
}
