% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc_main.R
\name{preproc_main}
\alias{preproc_main}
\title{A wrapper function for preproc_precondition_data, preproc_audit_data, and calc_annual_flow_stats}
\usage{
preproc_main(
  data = NULL,
  Date,
  value,
  date_format = "\%Y-\%m-\%d",
  year_group = c("WY", "CY", "year"),
  use_specific_years = FALSE,
  begin_year = NULL,
  end_year = NULL,
  days_cutoff = 360,
  calc_high = TRUE,
  calc_low = TRUE,
  calc_percentiles = TRUE,
  calc_monthly = TRUE,
  calc_WSCVD = TRUE,
  longitude = NA,
  calc_ICVD = FALSE,
  zero_threshold = 33,
  quantile_type = 8,
  na.action = c("na.omit", "na.pass")
)
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{Date} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{Date}{'Date' or 'character' vector when \code{data = NULL}, or 'character' string identifying
Date column name when \code{data} is specified. Dates associated with each value in \code{value}
parameter.}

\item{value}{'numeric' vector when \code{data = NULL}, or 'character' string identifying year column
name when \code{data} is specified. Values to precondition and calculate n-day moving averages
from. N-day moving averages only calculated for daily data.}

\item{date_format}{'character' string. Format of Date. Default is \code{"\%Y-\%m-\%d"}.}

\item{year_group}{'character' value. Specify either \code{"year"} for calendar year, \code{"WY"} for water
year, or \code{"CY"} for climate year. Used to select data after preconditioning for audit and
annual statistics. Default is \code{"WY"}.}

\item{use_specific_years}{'boolean' value. Flag to clip data to a certain set of years in
\code{year_group}. Default is \code{FALSE}.}

\item{begin_year}{'numeric' value. If \code{use_specific_years = TRUE}, beginning year to clip
\code{value}. Default is \code{NULL}.}

\item{end_year}{'numeric' value. If \code{use_specific_years = TRUE}, ending year to clip \code{value}.
Default is \code{NULL}.}

\item{days_cutoff}{'numeric' value. Designating the number of days required for a year to be
counted as full. Default is \code{360}.}

\item{calc_high}{'boolean' value. Calculate high streamflow statistics for years in \code{year_group}.
Default is \code{TRUE}. See \strong{Details} for more information.}

\item{calc_low}{'boolean' value. Calculate low streamflow statistics for years in \code{year_group}.
Default is \code{TRUE}. See \strong{Details} for more information.}

\item{calc_percentiles}{'boolean' value. Calculate percentiles for years in \code{year_group}.
Default is \code{TRUE}. See \strong{Details} for more information.}

\item{calc_monthly}{'boolean' value. Calculate monthly statistics for years in \code{year_group}.
Default is \code{TRUE}. See \strong{Details} for more information.}

\item{calc_WSCVD}{'boolean' value. Calculate winter-spring center volume date for years in
\code{year_group}. Default is \code{TRUE}. See \strong{Details} for more information.}

\item{longitude}{'numeric' value. Site longitude in NAD83, required in WSCVD calculation.
Default is \code{NA}. See \strong{Details} for more information.}

\item{calc_ICVD}{'boolean' value. Calculate inverse center volume date for years in
\code{year_group}. Default is \code{FALSE}. See \strong{Details} for more information.}

\item{zero_threshold}{'numeric' value as percentage. The percentage of years of a statistic that
need to be zero in order for it to be deemed a zero streamflow site for that statistic. For
use in trend calculation. See \strong{Details} on attributes. Default is \code{33} (33 percent) of
the annual statistic values.}

\item{quantile_type}{'numeric' value. The distribution type used in the \code{\link[stats:quantile]{stats::quantile}}
function. Default is \code{8} (median-unbiased regardless of distribution). Other
types common in hydrology are \code{6} (Weibull) or \code{9} (unbiased for normal distributions).}

\item{na.action}{'character' string indicating na.action passed to \code{\link[stats:aggregate]{stats::aggregate}}
\code{na.action} parameter. Default is \code{"na.omit"}, which removes \code{NA} values before aggregating
statistics, or \code{"na.pass"}, which will pass \code{NA} values and return \code{NA} in the grouped
calculation if any \code{NA} values are present.}
}
\value{
A list of three data.frames: 1 of preconditioned data, 1 data audit, and 1 annual
statistics.
}
\description{
A wrapper function for \code{\link{preproc_precondition_data}},
\code{\link{preproc_audit_data}}, and \cr \code{\link{calc_annual_flow_stats}}
}
\details{
This is a wrapper function of \code{\link{preproc_precondition_data}}, \code{\link{preproc_audit_data}}, and\cr
\code{\link{calc_annual_flow_stats}}. Data are first passed to the precondition function, then audited,
then annual statistics are computed.\cr
It also checks the timestep of the data to make sure that it is daily timestep.
Other time steps are currently not supported and will return the data.frame without moving
averages computed.
}
\examples{
preproc_main(data = example_obs, Date = "Date", value = "streamflow_cfs", longitude = -68)

}
\seealso{
\code{\link{preproc_audit_data}}, \code{\link{preproc_precondition_data}},
\code{\link{calc_annual_flow_stats}}
}
\keyword{annual-statistics}
\keyword{preprocessing-data}
