% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_ML.R
\name{GetUncertainty_ML}
\alias{GetUncertainty_ML}
\title{Maximum-likelihood estimation of uncertainty}
\usage{
GetUncertainty_ML(y, dist, par, nsim = nsim_def)
}
\arguments{
\item{y}{numeric vector, data}

\item{dist}{character, distribution name}

\item{par}{numeric vector, estimated parameter (using GetEstimate_ML()).}

\item{nsim}{integer, number of simulated parameter replicates.}
}
\value{
A list with the following components:
    \item{cov}{numeric matrix npar*npar, covariance matrix.}
    \item{sim}{numeric matrix nsim*npar, simulated parameter replicates.}
    \item{ok}{logical, did computation succeed?}
    \item{err}{integer, error code (0 if ok)}
    \item{message}{error message}
}
\description{
Returns an estimate of the uncertainty around the maximum-likelihood estimate, 
in the form of a covariance matrix and some simulations from the corresponding 
Gaussian distribution.
}
\examples{
y=c(9.2,9.5,11.4,9.5,9.4,9.6,10.5,11.1,10.5,10.4)
estim=GetEstimate_ML(y,'Gumbel',par0=GetEstimate_ROUGH(y,'Gumbel')$par)
GetUncertainty_ML(y,'Gumbel',par=estim$par)
}
