\name{sample_geom_hypergraph}
\alias{sample_geom_hypergraph}
\alias{plot_geom_hypergraph}
\title{
Construct a hypergraph from a random collection of points.
}
\description{
A hypergraph defined by the relationships amongst a set of points.
}
\usage{
sample_geom_hypergraph(n, m, d = 2, X, Y, radius,method = "Euclidean",
thresh.method="leq", uniformly = FALSE)
plot_geom_hypergraph(h, pch = 20, cex = 3, col = "gray",
plotY = TRUE, plot.circles = plotY,
full.circles=TRUE,
lty = 2, lcol = "black", ...)
}
\arguments{
  \item{n}{
The number of points to generate (ignored if \code{X} is provided).
This corresponds to the number of vertices in the hypergraph.
}
  \item{m}{
The number of nodes in the hypergraph (ignored if \code{Y} is provided).
This corresponds to the number of hyper-edges in the hypergraph.
}
  \item{d}{
dimension of the points (ignored if both \code{X} and \code{Y} are provided).
}
  \item{radius,uniformly}{
see Description.
}
  \item{X}{
see Description.
}
  \item{Y}{
see Description.
}
  \item{method}{
method passed to \code{\link[proxy]{dist}}.
}
  \item{thresh.method}{
if this is 'leq' then hyper-edges are defined by whether the Y points are
a distance less than or equal to the radius. If 'geq', then it is determined
by greater than. Any other value will default to 'leq'.
}
  \item{h}{
a hypergraph generated by \code{sample_geom_hypergraph}.
}
  \item{plotY}{
logical. Whether to plot the \code{Y} variables defining the hypergaph.
}
  \item{pch,cex,col}{
parameters controling the plotting of \code{Y}.
}
  \item{plot.circles,full.circles}{
logical. Whether to plot the circles defining the hyper-edges.
If \code{full.circles} is TRUE, the plot limits are set so that the 
complete circles are plotted. Otherwise they may be clipped.
} 
  \item{lty,lcol}{
parameters controling the plotting of the circles.
}
  \item{\dots}{
parameters passed to \code{plot}.
}
}
\details{
If either \code{X} or \code{Y} is missing, it is generated as a set of 
d-dimensional points in the unit cube, \code{n} points in \code{X}, 
\code{m} points in \code{Y}. If \code{X} is given, then \code{n} 
is ignored. Similary with \code{Y} and \code{m}. If both are given,
then \code{d} is ignored. There is no checking that the provided \code{X}
and/or \code{Y} matrices conform to the \code{n,m,d} values given in the 
call.

The inter-point distance matrix is computed using \code{\link[proxy]{dist}}
as \code{proxy::dist(Y,X,method=method)}. 
If \code{radius} is not provided, it is 
chosen uniformly at random from the unique values of the distance matrix 
if \code{uniformly} is FALSE, and uniformly from between the minimum and
maximum distance if \code{uniformly} is true. As a rule, one should not
let this function choose the radius, but the code will do so if you wish.
The matrix is then thresholded by the
radius, resulting in a binary matrix which is then used as the 
mxn incidence matrix for the hypergraph.
}
\note{
If both \code{X} and \code{Y} are given, and \code{R} is not given,
a random value for \code{R} is chosen randomly from the unique inter-point
distances.
If all three of these variables are provided, the hypergraph is not random.
}
\value{
a hypergraph. Additionally, the defining vectors \code{X} and \code{Y}
and the radius
are returned as named values of the hypergraph.
}
\author{
David J. Marchette \email{dmarchette@gmail.com}
}
\seealso{
\code{\link[proxy]{dist}}.
}
\examples{
	set.seed(235)
   h <- sample_geom_hypergraph(100,20,radius=0.2)
	set.seed(3519)
	Y <- matrix(runif(20),ncol=2)
	X <- do.call(rbind,
	     lapply(1:nrow(Y),function(i) cbind(rnorm(10,Y[i,1]),rnorm(10,Y[i,2]))))
	

   h <- sample_geom_hypergraph(X=X,Y=Y,radius=0.2)
}
\keyword{ hypergraphs }
