% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICV.R
\name{L_ICV}
\alias{L_ICV}
\title{The ICV selection kernel.}
\usage{
L_ICV(u, alpha, sigma)
}
\arguments{
\item{u}{numerical argument of the selection kernel,}

\item{alpha}{first parameter of the selection kernel,}

\item{sigma}{second parameter of the selection kernel.}
}
\value{
The value of \eqn{L(u;\alpha,\sigma)}.
}
\description{
The ICV selection kernel \eqn{L} defined by expression (4) of Savchuk, Hart, and Sheather (2010).
}
\details{
The ICV selection kernel \eqn{L(u;\alpha,\sigma)=(1+\alpha)\phi(u)-\alpha\phi(u/\sigma)/\sigma}, where \eqn{\phi} denotes the Gaussian kernel.
}
\examples{
\dontrun{
# Graph of the ICV selection kernel with (alpha,sigma)=(2.42,5.06).
u=seq(-10,10,len=1000)
kern=L_ICV(u,2.42,5.06)
dev.new()
plot(u,kern,'l',lwd=2,ylim=c(-0.2,1.2),ylab="kernel",cex.lab=1.7,cex.axis=1.7,main="")
lines(u,dnorm(u),lwd=3,lty="dashed")
title(main="Selection kernel with (alpha,sigma)=(2.42,5.06)",cex.main=1.6)
legend(-11, 1.2, legend=c("ICV kernel","Gaussian kernel"),lwd=c(3,3),lty=c(1,2),bty="n",cex=1.3)
}
}
\references{
Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2010). Indirect cross-validation for density estimation. \emph{Journal of the American Statistical Association}, 105(489), 415-423.
}
\seealso{
\code{\link{ICV}}, \code{\link{h_ICV}}, \code{\link{C_ICV}}, \code{\link{MISE_mixnorm}}, \code{\link{KDE_ICV}}, \code{\link{LocICV}}.
}

