% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KIC.R
\name{KIC}
\alias{KIC}
\alias{KICC}
\title{Kullback–Leibler Information Criterion}
\usage{
KIC(model)

KICC(model)
}
\arguments{
\item{model}{a "lm" or "glm" object}
}
\value{
KIC measurement of the model
}
\description{
Calculates Kullback–Leibler Information Criterion (KIC) and its corrected form (KICC) for "lm" and "glm" objects.
}
\details{
KIC (Seghouane, 2006) is calculated as

\deqn{-2LL(theta) + 3k}

and KICC (Seghouane, 2006) is calculated as

\deqn{-2LL(theta) + ((k + 1)(3n - k - 2)) + (k/(n-k))}
}
\examples{
x1 <- rnorm(100, 3, 2)
x2 <- rnorm(100, 5, 3)
x3 <- rnorm(100, 67, 5)
err <- rnorm(100, 0, 4)

## round so we can use it for Poisson regression
y <- round(3 + 2*x1 - 5*x2 + 8*x3 + err)

m1 <- lm(y~x1 + x2 + x3)
m2 <- glm(y~x1 + x2 + x3, family = "gaussian")
m3 <- glm(y~x1 + x2 + x3, family = "poisson")

KIC(m1)
KIC(m2)
KIC(m3)
KICC(m1)
KICC(m2)
KICC(m3)

}
\references{
Seghouane, A. K. (2006). A note on overfitting properties of KIC and KICC. Signal Processing, 86(10), 3055-3060.
}
