% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kSearch.R
\name{print.kSearch}
\alias{print.kSearch}
\title{Printing an Object of Class kSearch}
\usage{
\method{print}{kSearch}(x, digits = getOption("digits"), ...)
}
\arguments{
\item{x}{An object of class \code{kSearch}.}

\item{digits}{Number of significant digits to use when printing p-values. Defaults to \code{getOption("digits")}.}

\item{...}{Further arguments.}
}
\description{
Basic printing of an object of class \code{kSearch}. Prints the estimated dimension \code{k} along with
all tested values and corresponding p-values.
}
\examples{
n <- 500
S <- cbind(rnorm(n, sd = 2), rnorm(n, sd = 1.5), rnorm(n), rnorm(n))
A <- rorth(4)
X <- S \%*\% t(A)
result <- kSearch(X, method = PCAasymp)
result

}
\seealso{
\code{\link{summary.kSearch}}, \code{\link{kSearch}}
}
\author{
Katariina Perkonoja
}
\keyword{methods}
\keyword{print}
