% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gevdfit.R
\name{gev.d.fit}
\alias{gev.d.fit}
\title{Maximum-likelihood Fitting of the duration-dependent GEV Distribution}
\usage{
gev.d.fit(
  xdat,
  ds,
  ydat = NULL,
  mutl = NULL,
  sigma0l = NULL,
  xil = NULL,
  thetal = NULL,
  etal = NULL,
  taul = NULL,
  eta2l = NULL,
  mutlink = make.link("identity"),
  sigma0link = make.link("identity"),
  xilink = make.link("identity"),
  thetalink = make.link("identity"),
  etalink = make.link("identity"),
  taulink = make.link("identity"),
  eta2link = make.link("identity"),
  init.vals = NULL,
  theta_zero = FALSE,
  tau_zero = TRUE,
  eta2_zero = TRUE,
  show = TRUE,
  method = "Nelder-Mead",
  maxit = 10000,
  ...
)
}
\arguments{
\item{xdat}{A vector containing maxima for different durations.
This can be obtained from \code{\link{IDF.agg}}.}

\item{ds}{A vector of aggregation levels corresponding to the maxima in xdat.
1/60 corresponds to 1 minute, 1 corresponds to 1 hour.}

\item{ydat}{A matrix of covariates for generalized linear modeling of the parameters
(or NULL (the default) for stationary fitting). The number of rows should be the same as the
length of xdat.}

\item{mutl, sigma0l, xil, thetal, etal, taul, eta2l}{Numeric vectors of integers, giving the columns of ydat that contain
covariates for generalized linear modeling of the parameters (or NULL (the default)
if the corresponding parameter is stationary).
Parameters are: modified location, scale offset, shape, duration offset, duration exponent, respectively.}

\item{mutlink, sigma0link, xilink, thetalink, etalink, eta2link, taulink}{Link functions for generalized linear
modeling of the parameters, created with \code{\link{make.link}}. The default is \code{make.link("identity")}.}

\item{init.vals}{list, giving initial values for all or some parameters
(order: mut, sigma0, xi, theta, eta, eta2, tau). If one of those parameters shall not be used (see theta_zero, eta2_zero, tau_zero),
the number of parameters has to be reduced accordingly. If some or all given values in init.vals are NA or 
no init.vals at all is declared (the default), initial parameters are obtained
internally by fitting the GEV separately for each duration and applying a linear model to obtain the
duration dependency of the location and shape parameter.
Initial values for covariate parameters are assumed as 0 if not given.}

\item{theta_zero}{Logical value, indicating whether theta should be estimated (FALSE, the default) or
should stay zero.}

\item{tau_zero, eta2_zero}{Logical values, indicating whether tau,eta2 should be estimated (TRUE, the default).}

\item{show}{Logical; if TRUE (the default), print details of the fit.}

\item{method}{The optimization method used in \code{\link{optim}}.}

\item{maxit}{The maximum number of iterations.}

\item{...}{Other control parameters for the optimization.}
}
\value{
A list containing the following components.
A subset of these components are printed after the fit.
If \code{show} is TRUE, then assuming that successful convergence is indicated,
the components nllh, mle and se are always printed.
\item{nllh}{single numeric giving the negative log-likelihood value}
\item{mle}{numeric vector giving the MLE's for the modified location, scale_0, shape,
duration offset and duration exponent, resp. If requested, contains also second duration exponent and intensity-offset}
\item{se}{numeric vector giving the standard errors for the MLE's (in the same order)}
\item{trans}{A logical indicator for a non-stationary fit.}
\item{model}{A list with components mutl, sigma0l, xil, thetal and etal. If requested, contains also eta2l and taul}
\item{link}{A character vector giving link functions.}
\item{conv}{The convergence code, taken from the list returned by \code{\link{optim}}.
A zero indicates successful convergence.}
\item{data}{data is standardized to standard Gumbel.}
\item{cov}{The covariance matrix.}
\item{vals}{Parameter values for every data point.}
\item{init.vals}{Initial values that were used.}
\item{ds}{Durations for every data point.}
}
\description{
Modified \code{\link[ismev]{gev.fit}} function for Maximum-likelihood fitting
for the duration-dependent generalized extreme
value distribution, following Koutsoyiannis et al. (1998), including generalized linear
modeling of each parameter.
}
\details{
For details on the d-GEV and the parameter definitions, see \link{IDF-package}.
}
\examples{
# sampled random data from d-gev with covariates
# GEV parameters:
# mut = 4 + 0.2*cov1 +0.5*cov2
# sigma0 = 2+0.5*cov1
# xi = 0.5
# theta = 0
# eta = 0.5
# eta2 = 0
# tau = 0

data('example',package ='IDF')

gev.d.fit(xdat=example$dat,ds = example$d,ydat=as.matrix(example[,c('cov1','cov2')])
,mutl=c(1,2),sigma0l=1)
}
\seealso{
\code{\link{IDF-package}}, \code{\link{IDF.agg}}, \code{\link[ismev]{gev.fit}}, \code{\link{optim}}
}
