% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{normalise}
\alias{normalise}
\title{Transform the noise to be closer to the Gaussian distribution}
\usage{
normalise(x, sc = 3)
}
\arguments{
\item{x}{A numeric vector containing the data.}

\item{sc}{A positive integer number with default value equal to 3. It is
used to define the way we pre-average the given data sequence.}
}
\value{
The ``normalised'' vector \eqn{\tilde{x}} of length \eqn{Q}, as explained in Details.
}
\description{
This function pre-processes the given data in order to obtain a noise structure
that is closer to satisfying the Gaussianity assumption. See details for more information
and for the relevant literature reference.
}
\details{
For a given natural number \code{sc} and data \code{x} of length \eqn{T}, let us
denote by \eqn{Q = \lceil T/sc \rceil}. Then, \code{\link{normalise}} calculates
\deqn{\tilde{x}_q = 1/sc\sum_{t=(q-1) * sc + 1}^{q * sc}x_t,} for \eqn{q=1, 2, ..., Q-1}, while
\deqn{\tilde{x}_Q = (T - (Q-1) * sc)^{-1}\sum_{t = (Q-1) * sc + 1}^{T}x_t.}
More details can be found in the preprint ``Detecting multiple generalized
change-points by isolating single ones'', Anastasiou and Fryzlewicz (2018).
}
\examples{
t5 <- rt(n = 10000, df = 5)
n5 <- normalise(t5, sc = 3)
}
\seealso{
\code{\link{ht_ID_pcm}} and \code{\link{ht_ID_cplm}}, which are
 functions that employ \code{\link{normalise}}.
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
