% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getImagesValues.R
\name{getImagesValues}
\alias{getImagesValues}
\title{RIF/CIF Image Values Extraction}
\usage{
getImagesValues(
  fileName,
  offsets,
  objects,
  display_progress = FALSE,
  fast = TRUE,
  ...
)
}
\arguments{
\item{fileName}{path to file.}

\item{offsets}{Object of class `IFC_offset`. If missing, the default, 'offsets' will be extracted from 'fileName'.\cr
This param is not mandatory but it may allow to save time when exporting repeated image value on same file.}

\item{objects}{integer vector, IDEAS objects ids numbers to extract.\cr
If missing, the default, images values from all objects will be extracted.}

\item{display_progress}{whether to display a progress bar. Default is FALSE.}

\item{fast}{when no 'offsets' are provided whether to fast extract 'objects' or not. Default is TRUE.\cr
Meaning that 'objects' will be extracted expecting that 'objects' are stored in ascending order.\cr
Only apply when 'offsets' are not provided.\cr
Note that a warning will be sent if an object is found at an unexpected order.}

\item{...}{other arguments to be passed.}
}
\value{
A data.frame is returned.
}
\description{
Extracts the image values from RIF or CIF as what can be found in DAF files
}
\keyword{internal}
