% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popsCopy.R
\name{popsCopy}
\alias{popsCopy}
\title{Copy Populations from One File to Another File}
\usage{
popsCopy(
  from,
  into,
  write_to,
  pops,
  use_regex = FALSE,
  overwrite = FALSE,
  append_name = TRUE,
  offset = 0,
  endianness = .Platform$endian,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{from}{path to file to copy populations from.}

\item{into}{path to file that will be used as a template to copy population into.
Caution, it is mandatory that 'into' contains 'from' starting at 'offset'.}

\item{write_to}{pattern used to export file.
Placeholders, like "\%d/\%s_fromR.\%e", will be substituted:\cr
-\%d: with full path directory of 'into'\cr
-\%p: with first parent directory of 'into'\cr
-\%e: with extension of 'into' (without leading .)\cr
-\%s: with shortname from 'into' (i.e. basename without extension).\cr
Exported file extension will be deduced from this pattern. Note that it has to be a .daf.}

\item{pops}{regular expression or vector of desired populations present in 'from'.\cr
If missing, the default, all populations found will be copied.\cr
If given but not found, a warning will be sent.}

\item{use_regex}{whether to use regex to pick up population into 'from'. Default is FALSE.}

\item{overwrite}{whether to overwrite existing file or not. Default is FALSE.
Note that if TRUE, it will overwrite exported file if path of 'into' and deduced from 'write_to' arguments are different.
Otherwise, you will get an error saying that overwriting source file is not allowed.\cr
Note also that an original file, i.e. generated by IDEAS(R) or INSPIRE(R), will never be overwritten.
Otherwise, you will get an error saying that overwriting original file is not allowed.\cr}

\item{append_name}{whether to append_name basename(from) to exported populations. Default is TRUE.}

\item{offset}{Object number of 1st object of 'from' in 'into'. Default is 0.}

\item{endianness}{The endian-ness ("big" or "little") of the target system for the file. Default is .Platform$endian.\cr
Endianness describes the bytes order of data stored within the files. This parameter may not be modified.}

\item{verbose}{whether to display information (use for debugging purpose). Default is FALSE.}

\item{...}{Other arguments to be passed.}
}
\value{
a new file is created containing exported populations.\cr
It invisibly returns full path of exported file.
}
\description{
Copies populations from a DAF file into a copy of another DAF file.
Only creates new file with copied population.
}
\details{
Populations are exported as tagged populations.
}
