#' Missing to NAs
#'
#' Converts values labelled as missings to \code{NA}.
#' 
#' @param tibble a tibble object.
#'
#' @returns A tibble.
#' 
#' @keywords tibblemanagement
#' 
#' @examples
#' # tibble generated by haven
#' input <- system.file("extdata/reds", package = "ILSAmerge")
#' tib <- do.call(rbind,justload(inputdir = input,population = "BCGV1"))
#' 
#' tib
#' 
#' mistoNAs(tib)
#'
#' @export
#

mistoNAs <- function(tibble){
  
  # requireNamespace(haven)
  # library(haven)
  # tibble = data[,c(1:224,226:300)]
  
  try(haven::print_labels(),silent = TRUE)
  
  if(!inherits(tibble, "tbl_df"))
    stop(c("\nInvalid input for 'tibble'.",
           "\nIt should be a tibble."),call. = FALSE)
  
  tibble[is.na(tibble)] <- NA
  return(tibble)
  
}
