% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ils.fqcs.R
\name{plot.mandel.fqcs}
\alias{plot.mandel.fqcs}
\title{Plotting method for 'mandel.fqcs' objects}
\usage{
\method{plot}{mandel.fqcs}(
  x,
  xlab = NULL,
  ylab = NULL,
  x.co = NULL,
  y.co = NULL,
  legend = TRUE,
  col = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class \code{mandel.fqcs}.}

\item{xlab}{Title for the x axis.}

\item{ylab}{Title for the y axis.}

\item{x.co}{It speficies the x co-ordinates to be used to place a legend.}

\item{y.co}{It specifies the y co-ordinates to be used to place a legend.}

\item{legend}{Logical argument. Default is TRUE then The legend default is used.}

\item{col}{Color specifications.}

\item{...}{Other arguments to be passed to or from methods.}
}
\description{
Generic function to plot objects of 'mandel.fqcs' class. Results of functional ILS studies are graphically shown.
}
\examples{
\dontrun{
library(ILS)
data(TG)
delta <- seq(from = 40 ,to = 850 ,length.out = 1000 )
fqcdata <- ils.fqcdata(TG, p = 7, argvals = delta)
mandel.tg <- mandel.fqcs(fqcdata.tg,nb = 200)
plot(mandel.tg,legend = F,col=c(rep(3,5),1,1))
  }
# $H(t)$ y $K(t)$

}
\references{
Febrero-Bande, M. and Oviedo, M. (2012),
"Statistical computing in functional data analysis: the R package fda.usc". Journal of Statistical Software 51 (4), 1-28.

Naya, S., Tarrio-Saavedra. J., Lopez- Beceiro, J., Francisco Fernandez, M., Flores, M. and  Artiaga, R. (2014),
"Statistical functional approach for interlaboratory studies with thermal data". Journal of Thermal Analysis and Calorimetry, 118,1229-1243.
}
