% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inlavaan.R
\name{inlavaan}
\alias{inlavaan}
\title{Fit an Approximate Bayesian Latent Variable Model}
\usage{
inlavaan(
  model,
  data,
  model.type = "sem",
  dp = blavaan::dpriors(),
  vb_correction = TRUE,
  marginal_method = c("skewnorm", "asymgaus", "marggaus", "sampling"),
  marginal_correction = c("shortcut", "hessian", "none"),
  nsamp = 500,
  test = "standard",
  sn_fit_logthresh = -6,
  sn_fit_temp = NA,
  control = list(),
  verbose = TRUE,
  debug = FALSE,
  add_priors = TRUE,
  optim_method = c("nlminb", "ucminf", "optim"),
  numerical_grad = FALSE,
  ...
)
}
\arguments{
\item{model}{A description of the user-specified model. Typically, the model
    is described using the lavaan model syntax. See 
    \code{\link[lavaan]{model.syntax}} for more information. Alternatively, a
    parameter table (eg. the output of the \code{lavParTable()} function) is also
    accepted.}

\item{data}{An optional data frame containing the observed variables used in
    the model. If some variables are declared as ordered factors, lavaan will
    treat them as ordinal variables.}

\item{model.type}{Set the model type: possible values
    are \code{"cfa"}, \code{"sem"} or \code{"growth"}. This may affect
    how starting values are computed, and may be used to alter the terminology
    used in the summary output, or the layout of path diagrams that are
    based on a fitted lavaan object.}

\item{dp}{Default prior distributions on different types of
    parameters, typically the result of a call to \code{dpriors()}.
    See the \code{dpriors()} help file for more information.}

\item{vb_correction}{Logical indicating whether to apply a variational Bayes
correction for the posterior mean vector of estimates. Defaults to \code{TRUE}.}

\item{marginal_method}{The method for approximating the marginal posterior
distributions. Options include \code{"skewnorm"} (skew normal), \code{"asymgaus"}
(two-piece asymmetric Gaussian), \code{"marggaus"} (marginalising the Laplace
approximation), and \code{"sampling"} (sampling from the joint Laplace
approximation).}

\item{marginal_correction}{Which type of correction to use when fitting the
skew normal or two-piece Gaussian marginals. \code{"hessian"} computes the full
Hessian-based correction (slow), \code{"shortcut"} (default) computes only
diagonals, and \code{"none"} (or \code{FALSE}) applies no correction.}

\item{nsamp}{The number of samples to draw for all sampling-based approaches
(including posterior sampling for model fit indices).}

\item{test}{Character indicating whether to compute posterior fit indices.
Defaults to "standard". Change to "none" to skip these computations.}

\item{sn_fit_logthresh}{The log-threshold for fitting the skew normal. Points
with log-posterior drop below this threshold (relative to the maximum) will
be excluded from the fit. Defaults to \code{-6}.}

\item{sn_fit_temp}{Temperature parameter for fitting the skew normal. If
\code{NA}, the temperature will be included in the optimisation during the skew
normal fit.}

\item{control}{A list of control parameters for the optimiser.}

\item{verbose}{Logical indicating whether to print progress messages.}

\item{debug}{Logical indicating whether to return debug information.}

\item{add_priors}{Logical indicating whether to include prior densities in
the posterior computation.}

\item{optim_method}{The optimisation method to use for finding the posterior
mode. Options include \code{"nlminb"} (default), \code{"ucminf"}, and \code{"optim"}
(BFGS).}

\item{numerical_grad}{Logical indicating whether to use numerical gradients
for the optimisation.}

\item{...}{Additional arguments to be passed to the \link[lavaan:lavaan]{lavaan::lavaan} model fitting
function.}
}
\value{
An S4 object of class \code{INLAvaan} which is a subclass of the
\link[lavaan:lavaan-class]{lavaan::lavaan} class.
}
\description{
This function fits a Bayesian latent variable model by approximating the
posterior distributions of the model parameters using various methods,
including skew normal, asymmetric Gaussian, marginal Gaussian, or
sampling-based approaches. It leverages the lavaan package for model
specification and estimation.
}
\examples{
# The Holzinger and Swineford (1939) example
HS.model <- "
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
"
utils::data("HolzingerSwineford1939", package = "lavaan")

fit <- inlavaan(
  HS.model,
  data = HolzingerSwineford1939,
  auto.var = TRUE,
  auto.fix.first = TRUE,
  auto.cov.lv.x = TRUE
)
summary(fit)
}
\seealso{
Typically, users will interact with the specific latent variable
model functions instead, including \code{\link[=acfa]{acfa()}}, \code{\link[=asem]{asem()}}, and \code{\link[=agrowth]{agrowth()}}.
}
