% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISCA_clustertable.R
\name{ISCA_clustertable}
\alias{ISCA_clustertable}
\title{ISCA Cluster Tables}
\usage{
ISCA_clustertable(data, cluster_vars, draws = 500)
}
\arguments{
\item{data}{The dataset including all relevant variables and the random assignments from the first ISCA_random_assignments()-function.}

\item{cluster_vars}{A vector specifying the variables of interest.}

\item{draws}{Specification of the number of probabilistic draws. The number of draws should be equal to the number of draws specified in the first step. If not specified, the default is 500.}
}
\value{
The output is a table containing the grand mean, grand standard deviation, and cluster error for each variable and cluster. No cluster error is calculated for dichotomous variables.
}
\description{
Function to create a cluster or descriptive table across iterations.
}
\examples{
data(sim_data)
ISCA_step1 <- ISCA_random_assignments(data=sim_data, filter=native, 
majority_group=1, minority_group=c(0), fuzzifier = 1.5, n_clusters=4, 
draws=5, cluster_vars= c("female", "age", "education", "income"))
result_ISCA_clustertable <- ISCA_clustertable(data = ISCA_step1, 
cluster_vars = c("native", "education", "age", "female", 
"discrimination", "religiosity"), draws = 5);
}
