% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_p_Gaussian.R
\name{get_p_Gaussian}
\alias{get_p_Gaussian}
\title{get_p_Gaussian}
\usage{
get_p_Gaussian(X, y, x0, tau)
}
\arguments{
\item{X}{a numeric matrix specifying the covariates.}

\item{y}{a numeric vector with \code{length(y) == nrow(X)} specifying the
responses.}

\item{x0}{a numeric vector specifying the point of interest, such that
\code{length(x0) == ncol(X)}.}

\item{tau}{a single numeric value specifying the threshold of interest.}
}
\value{
A single numeric value in (0, 1].
}
\description{
Calculate the p-value in Definition 19 of \insertCite{MRCS2023;textual}{ISS}.
}
\examples{
set.seed(123)
n <- 100
d <- 2
X <- matrix(runif(d * n), ncol = d)
eta <- function(x) sum(x)
y <- apply(X, MARGIN = 1, FUN = eta) + rnorm(n, sd = 1)
get_p_Gaussian(X, y, x0 = c(1, 1), tau = 1)
get_p_Gaussian(X, y, x0 = c(1, 1), tau = -1)


}
\references{
\insertRef{MRCS2023}{ISS}
}
