% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_p_classification.R
\name{get_p_classification}
\alias{get_p_classification}
\title{get_p_classification}
\usage{
get_p_classification(X, y, x0, tau)
}
\arguments{
\item{X}{a numeric matrix specifying the covariates.}

\item{y}{a numeric vector with \code{length(y) == nrow(X)} and \code{all((y >= 0) & (y <= 1))} specifying the responses.}

\item{x0}{a numeric vector specifying the point of interest, such that
\code{length(x0) == ncol(X)}.}

\item{tau}{a single numeric value in [0,1) specifying the threshold of interest.}
}
\value{
A single numeric value in (0, 1].
}
\description{
Calculate the p-value in Definition 21 of \insertCite{MRCS2023;textual}{ISS}.
}
\examples{
set.seed(123)
n <- 100
d <- 2
X <- matrix(runif(d * n), ncol = d)
eta <- function(x) sum(x)
X_eta <- apply(X, MARGIN = 1, FUN = function(x) 1 / (1 + exp(-eta(x))))
y <- as.numeric(runif(n) < X_eta)
get_p_classification(X, y, x0 = c(1, 1), tau = 0.6)
get_p_classification(X, y, x0 = c(1, 1), tau = 0.9)
}
\references{
\insertRef{MRCS2023}{ISS}
}
