% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVC.R
\name{IVCT_Interval}
\alias{IVCT_Interval}
\title{Integrated Variance Correlation Based Interval Independence Hypothesis Test}
\usage{
IVCT_Interval(y, x, tau1, tau2, K, num_per, NN = 3, type)
}
\arguments{
\item{y}{is the response vector}

\item{x}{is a numeric vector or a data matrix}

\item{tau1}{is the minimum quantile level}

\item{tau2}{is the maximum quantile level}

\item{K}{is the number of quantile levels}

\item{num_per}{is the number of permutation times}

\item{NN}{is the number of B spline basis, default is 3}

\item{type}{is an indicator for measuring linear or nonlinear correlation, "linear" represents linear correlation and "nonlinear" represents linear or nonlinear correlation using B splines}
}
\value{
The p-value of the corresponding hypothesis test
}
\description{
This function is used to test interval independence using integrated variance correlation
}
\examples{
require("mvtnorm")
n=100
p=3
pho1=0.5
mean_x=rep(0,p)
sigma_x=matrix(NA,nrow = p,ncol = p)
for (i in 1:p) {
 for (j in 1:p) {
   sigma_x[i,j]=pho1^(abs(i-j))
 }
}
x=rmvnorm(n, mean = mean_x, sigma = sigma_x,method = "chol")
y=rnorm(n)

IVCT_Interval(y,x,tau1=0.5,tau2=0.75,K=5,num_per=20,type = "linear")

n=100
x_til=runif(n,min=-1,max=1)
y_til=rnorm(n)
epsilon=rnorm(n)
x=x_til+2*epsilon*ifelse(x_til<=-0.5&y_til<=-0.675,1,0)
y=y_til+2*epsilon*ifelse(x_til<=-0.5&y_til<=-0.675,1,0)

IVCT_Interval(y,x,tau1=0.6,tau2=0.8,K=5,num_per=20,type = "nonlinear")
}
