% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igaprobabilityratio.R
\name{igaprobabilityratio}
\alias{igaprobabilityratio}
\title{IgA Probability Ratio}
\usage{
igaprobabilityratio(
  posabund,
  negabund,
  possize,
  negsize,
  pseudo = 1e-05,
  scaleratio = TRUE,
  nazeros = TRUE
)
}
\arguments{
\item{posabund}{Abundance of the bacteria in the IgA positive/high fraction (abundances should sum to 1 not as a \%).}

\item{negabund}{Abundance of the bacteria in the IgA negative/low fraction (abundances should sum to 1 not as a \%).}

\item{possize}{The fraction of events in the flow cytometer classed as IgA positive/high (as a decimal fraction not a \%).}

\item{negsize}{The fraction of events in the flow cytometer classed as IgA negative/low (as a decimal fraction not a \%).}

\item{pseudo}{Pseudo count added to both the IgA positive and negative abundance values prior to calculation. Defaults to 1e-5. Recommend setting to minimum observed abundance in whole dataset.}

\item{scaleratio}{Should probratio scores be scaled to the pseudo count. Default is TRUE.}

\item{nazeros}{Return NA if the pos and neg abundances are both zero. Default is TRUE.}
}
\value{
A numeric value for the IgA Probability Ratio as defined in Jackson et al. (2020, \doi{10.1101/2020.08.19.257501}).
}
\description{
Calculate the IgA Probability Ratio score as described in Jackson et al. (2020, \doi{10.1101/2020.08.19.257501}).
}
\details{
This function calculates the ratio of the immunoglobulin A (IgA) positive fraction probability relative to the IgA negative fraction probability for a single taxa in a single sample.
These probabilities can individually be calculated using the igaprobability() function. As both calculations have the whole fraction taxon abundance as a denominator it cancels.
This means the IgA probability ratio can be calculated without this information.
Further details can be found in Jackson et al. (2020, \doi{10.1101/2020.08.19.257501}).
}
\examples{
igaprobabilityratio(posabund=0.2,negabund=0.05,possize=0.05,negsize=0.6,pseudo=0.0002)
}
\keyword{iga}
\keyword{iga-seq}
\keyword{probability}
\keyword{ratio}
