% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igascores.R
\name{igascores}
\alias{igascores}
\title{Generate various scores for IgA binding in IgA-Seq experiments}
\usage{
igascores(
  posabunds = NULL,
  negabunds = NULL,
  possizes = NULL,
  negsizes = NULL,
  pseudo = NULL,
  presortabunds = NULL,
  method = "probratio",
  scaleratio = TRUE,
  nazeros = TRUE
)
}
\arguments{
\item{posabunds}{A dataframe of taxa abundances in the positive/high IgA gate samples. Samples as columns and taxa as rows, column and row names must match across abundance tables.}

\item{negabunds}{A dataframe of taxa abundances in the negative/low IgA gate samples. Samples as columns and taxa as rows, column and row names must match across abundance tables.}

\item{possizes}{A named vector containing the fraction of events in the IgA positive gate for each sample, with sample names matching abundance dataframes.}

\item{negsizes}{A named vector containing the fraction of events in the IgA negative gate for each sample, with sample names matching abundance dataframes.}

\item{pseudo}{The pseudo count to be used in scores. Default is 1e-5. Recommend setting to minimum observed abundance.}

\item{presortabunds}{A dataframe of taxa abundances in the whole/initial samples. Samples as columns and taxa as rows, column and row names must match across abundance tables.}

\item{method}{Method to use to score IgA binding. One of: "probratio","prob","kau","palm". Default is "probratio".}

\item{scaleratio}{Should probratio scores be scaled to the pseudo count. Default is TRUE.}

\item{nazeros}{Should taxa with zero abundance in both the posabunds and negabunds (posabunds and presortabunds for prob method)  be scored as NA. Default is TRUE.}
}
\value{
A data frame of IgA binding scores for all taxa and samples in the input data frame, generated using the scoring appraoch specified in 'method'.
}
\description{
Calculate various different IgA-Seq scores across all the taxa and samples in an experiment.
}
\details{
This function enables calculation of a variety of different indices for scoring immunoglobulin A (IgA) binding to taxa in IgA sequencing (IgA-Seq) experiments.
It is designed to be called on dataframes of abundance values, allowing easy calculation of scores across multiple taxa and samples.
The igaprobabilityratio(), igaprobability(), kauindex() and palmindex() functions can be used to calculate scores for one taxa and one sample.

Scoring method can be chosen by specifying the method parameter as one of: "probratio", "prob", "kau", "palm" (Defaults to "probratio").
Each method requires different inputs as detailed below:

\itemize{
\item probratio - equivalent to igaprobabilityratio() - requires two separate dataframes with iga positive abundances and iga negative abundances, two vectors with the sizes of the iga positive and negative gates per sample, and a pseudo count
\item prob - equivalent to igaprobability() - requires a dataframe with iga pos or neg fraction abundances, a vector of iga pos or neg gate size per sample, and a dataframe of taxa abundances in the presort samples
\item kau - equivalent to kauindex() - requires two separate dataframes with iga positive abundances and iga negative abundances, and a pseudo count
\item palm - equivalent to palmindex() - requires two separate dataframes with iga positive abundances and iga negative abundances, and a pseudo count
}
}
\examples{
pab <- data.frame(Samp1=c(0.01,0.02,0.03),Samp2=c(0.05,0.02,0.04))
rownames(pab) <- c("Taxon1","Taxon2","Taxon3")
nab <- data.frame(Samp1=c(0.08,0.2,0.11),Samp2=c(0.05,0.0,0.07))
rownames(nab) <- c("Taxon1","Taxon2","Taxon3")
ps <- c(0.04,0.1)
ns <- c(0.08,0.4)
preab <- data.frame(Samp1=c(0.1,0.3,0.2),Samp2=c(0.15,0.05,0.2))
rownames(preab) <- c("Taxon1","Taxon2","Taxon3")
igascores(posabunds=pab,negabunds=nab, possizes=ps, negsizes=ns,pseudo=0.009)
igascores(posabunds=pab, possizes=ps, presortabunds=preab, method="prob")
igascores(posabunds=pab, negabunds=nab, pseudo=0.009, method="palm")
igascores(posabunds=pab, negabunds=nab, pseudo=0.009, method="kau")
}
\keyword{Kau}
\keyword{Palm}
\keyword{experiment}
\keyword{iga}
\keyword{iga-seq}
\keyword{index}
\keyword{probability}
\keyword{ratio}
\keyword{score}
