% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabund.R
\name{relabund}
\alias{relabund}
\title{Relative Abundance from Counts}
\usage{
relabund(counttable, percentage = FALSE)
}
\arguments{
\item{counttable}{Data frame of numeric values with rows as observations and columns as samples.}

\item{percentage}{Should values be returned as a percentage? i.e multiplied by 100. Default is FALSE (as required for most IgA scoring approaches).}
}
\value{
A data frame of the input data normalised by column (to sum to either 1 or 100).
}
\description{
This function converts values in a dataframe to a fraction/percentage of the sum of their column.
}
\examples{
taxcounts <- data.frame(Sample1=c(1,2,10,10),Sample2=c(3,10,5,1))
rownames(taxcounts) <- c("Taxon1","Taxon2","Taxon3","Taxon4")
relabund(taxcounts)
}
\keyword{abundance}
\keyword{microbiome}
\keyword{normalisation}
\keyword{relative}
