#' Read binary files saved by Igor Pro (including Neuromatic data)
#'
#' This package provides function to read data from the Igor Pro data analysis
#' program by Wavemetrics. The data formats supported are Igor packed experiment
#' format (\code{.pxp}) and Igor binary wave (\code{.ibw}). See:
#' \url{https://www.wavemetrics.com/} for details.
#'
#' It also includes some functions to load special pxp files produced by the
#' Neuromatic/Nclamp packages for recording and analysing neuronal #data. See
#' \url{https://github.com/SilverLabUCL/NeuroMatic} for details.
#'
#' Key functions in the package include \code{\link{read.ibw}},
#' \code{\link{read.pxp}}.
#'
#' @name IgorR-package
#' @aliases IgorR
#' @keywords package
"_PACKAGE"
