% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadIgorBinary.R
\name{read.pxp}
\alias{read.pxp}
\title{Reads an Igor Pro Packed Experiment (.pxp) file}
\usage{
read.pxp(
  pxpfile,
  regex,
  ReturnTimeSeries = FALSE,
  Verbose = FALSE,
  StructureOnly = FALSE,
  ExtractText = FALSE,
  IgorPlatform = NULL,
  ...
)
}
\arguments{
\item{pxpfile}{character vector naming a PXP file or an R \link{connection}.}

\item{regex}{if \code{TRUE}, only read records (e.g. waves) in the PXP file
whose names match a \link{regex}.}

\item{ReturnTimeSeries}{if \code{TRUE}, Igor waves are returned as a
\code{link{ts}} object with sensible x scaling (\code{FALSE} by default).}

\item{Verbose}{whether to print information to console during loading 
(numeric values are also allowed 0=none, 1=basic, 2=all).}

\item{StructureOnly}{(TODO) if \code{TRUE}, only the structure of the PXP
file for inspection.}

\item{ExtractText}{whether to extract procedures, recreation macros, history 
and plain text notebooks (\code{FALSE} by default).}

\item{IgorPlatform}{OS on which Igor file was saved (windows or macintosh).}

\item{...}{optional parameters passed to \link{read.ibw}.}
}
\value{
A list containing all the individual waves or variables in the PXP 
  file.
}
\description{
Note that PXP files are only partially documented so some contents cannot be 
parsed (e.g. image data). This function currently reads data records (Igor 
waves and variables), history, procedures, recreation macros and plain text 
notebooks. Formatted notebooks cannot be read.
}
\details{
\code{IgorPlatform} will determine in which encoding text is read 
(WINDOWS-1252 for windows and macintosh for macintosh). Unique abbreviations 
are acceptable. Defaults to \code{"windows"} on Windows, \code{"macintosh"}
otherwise. Note that Igor Pro 5.5 added a PlatformRecord to the PXP file
format which is used to determine the file's platform of origin when
available. Since this is information straight from the horse's mouth it will
override the \code{IgorPlatform} argument.
}
\examples{
r=read.pxp(system.file("igor","testexpt.pxp",package="IgorR"))
}
\seealso{
Other igor-io: 
\code{\link{WaveToTimeSeries}()},
\code{\link{read.ibw}()}
}
\author{
jefferis
}
\concept{igor-io}
