% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-sum.R
\docType{methods}
\name{sum}
\alias{sum}
\alias{sum,IntervalList-method}
\title{Calculate the sum of \eqn{n} intervals}
\usage{
\S4method{sum}{IntervalList}(x)
}
\arguments{
\item{x}{A list of intervals stored as an \code{IntervalList} object.}
}
\value{
This function returns an \code{IntervalData} object with the calculated
sum of the given \eqn{n} intervals, which is defined
as another nonempty compact real interval.
}
\description{
This function calculates the sum of \eqn{n} nonempty compact real intervals.
}
\details{
This function generalizes the Minkowski's sum of two nonempty compact real
intervals explained in \link{arithmetic} section and implemented through
\code{+} operator's method for two \code{IntervalData} objects.
}
\examples{
## The following code calculates the sum
## of a list with two different intervals
list <- IntervalList(c(1, 3), c(2, 5))
sum(list)
}
\references{
Hankin, R.K.S. (2010). A step-by-step guide to writing a simple package
that uses S4 methods: a "hello world" example. Technical Report.
Auckland University of Technology.
}
\seealso{
For further information of the interval arithmetic see \link{arithmetic}.
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
