/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.Enumeration;
import java.util.Vector;
import org.rosuda.ibase.Dependent;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.util.Global;

public class Notifier {
    Vector ton;
    int batchMode = 0;
    NotifyMsg batchLastMsg = null;

    public void addDepend(Dependent c) {
        if (this.ton == null) {
            this.ton = new Vector();
        }
        if (!this.ton.contains(c)) {
            this.ton.addElement(c);
        }
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): add [" + c.toString() + "]");
        }
    }

    public void delDepend(Dependent c) {
        if (this.ton != null) {
            this.ton.removeElement(c);
        }
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): remove [" + c.toString() + "]");
        }
    }

    public void NotifyAll(NotifyMsg msg, Dependent c) {
        this.NotifyAll(msg, c, null);
    }

    public void NotifyAll(NotifyMsg msg, Vector path) {
        this.NotifyAll(msg, null, path);
    }

    public void startCascadedNotifyAll(NotifyMsg msg) {
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): startCascadedNotifyAll(" + msg + ")");
        }
        Vector<Notifier> path = new Vector<Notifier>();
        path.addElement(this);
        this.NotifyAll(msg, null, path);
    }

    public void NotifyAll(NotifyMsg msg, Dependent c, Vector path) {
        if (Global.DEBUG > 1) {
            System.out.println("Notifier(" + this.toString() + "): send to all message " + msg);
        }
        if (this.batchMode > 0 || this.ton == null || this.ton.isEmpty()) {
            return;
        }
        Enumeration e = this.ton.elements();
        while (e.hasMoreElements()) {
            Dependent o = (Dependent)e.nextElement();
            if (o == c) continue;
            if (Global.DEBUG > 0) {
                System.out.println("Notifier(" + this.toString() + "): send " + msg + " to [" + o.toString() + "]");
            }
            if (path != null) {
                path.addElement(this);
                o.Notifying(msg, this, path);
                path.removeElement(this);
                continue;
            }
            o.Notifying(msg, this, null);
        }
    }

    public void NotifyAll(NotifyMsg msg) {
        this.NotifyAll(msg, null, null);
    }

    public void beginBatch() {
        ++this.batchMode;
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): begin batch #" + this.batchMode);
        }
    }

    public void endBatch() {
        if (Global.DEBUG > 0) {
            System.out.println("Notifier(" + this.toString() + "): end batch #" + this.batchMode);
        }
        if (this.batchMode > 0) {
            --this.batchMode;
        }
        if (this.batchMode == 0 && this.batchLastMsg != null) {
            this.NotifyAll(this.batchLastMsg);
            this.batchLastMsg = null;
        }
    }
}

