% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmstB.R
\name{jmstB}
\alias{jmstB}
\title{Joint model for Bidirectional survival data using \code{rstanarm}}
\usage{
jmstB(
  dtlong,
  dtsurv,
  longm,
  survm,
  timeVar,
  id,
  nchain = 1,
  refresh = 1000,
  BIGdata = FALSE,
  samplesize = 200
)
}
\arguments{
\item{dtlong}{longitudinal data}

\item{dtsurv}{survival data with two event status along with event time}

\item{longm}{longitudinal model e.g. list(serBilir~drug * year+(year|id),serBilir ~ drug * year+(year|id))}

\item{survm}{survival model e.g. list(Surv(years,status2)~drug,Surv(time_2,status_2)~drug+age)}

\item{timeVar}{time variable}

\item{id}{ID variable}

\item{nchain}{number of MCMC chain}

\item{refresh}{number of refresh sample}

\item{BIGdata}{logical argument TRUE or FALSE}

\item{samplesize}{samplesize for bigdata}
}
\value{
Estimated model parameters of Joint model with bidirectional survival data
}
\description{
The function fits joint model for survival data with two events. It utilizes the rstanarm package for obtaining the model parameter estimates.
}
\examples{
 \donttest{
 ##
library(JMbayes2)
library(rstanarm)
st_pbcid<-function(){
  new_pbcid<-pbc2.id
  new_pbcid$time_2<-rexp(n=nrow(pbc2.id),1/10)
  cen_time<-runif(nrow(pbc2.id),min(new_pbcid$time_2),max(new_pbcid$time_2))
  status_2<-ifelse(new_pbcid$time_2<cen_time,1,0)
  new_pbcid$status_2<-status_2
  new_pbcid$time_2<-ifelse(new_pbcid$time_2<cen_time,new_pbcid$time_2,cen_time)
  new_pbcid$time_2<-ifelse(new_pbcid$time_2<new_pbcid$years,new_pbcid$years,
                           new_pbcid$time_2)
  new_pbcid
}
new_pbc2id<-st_pbcid()
pbc2$status_2<-rep(new_pbc2id$status_2,times=data.frame(table(pbc2$id))$Freq)
pbc2$time_2<-rep(new_pbc2id$time_2,times=data.frame(table(pbc2$id))$Freq)
pbc2_new<-pbc2[pbc2$id\%in\%c(1:50),]
new_pbc2id<-new_pbc2id[new_pbc2id$id\%in\%c(1:50),]
model_jmstBdirect<-jmstB(
  dtlong=pbc2_new,
  dtsurv = new_pbc2id,
  longm=list(serBilir~drug*year+(year|id),albumin~drug+year+(year|id)),
  survm=list(Surv(years,status2)~drug,Surv(time_2,status_2)~drug),
  timeVar="year",
  id='id',
  refresh=400,
  nchain=1)
model_jmstBdirect
##
 }
}
\references{
Goodrich, B., et al. "rstanarm: Bayesian applied regression modeling via Stan. R package version 2.17. 4." Online< http://mc-stan. org (2018).

Bhattacharjee, A., Rajbongshi, B. K., & Vishwakarma, G. K. (2024). jmBIG: enhancing dynamic risk prediction and personalized medicine through joint modeling of longitudinal and survival data in big routinely collected data. BMC Medical Research Methodology, 24(1), 172.
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
