% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_support.R
\name{predict.ps2dnormal}
\alias{predict.ps2dnormal}
\title{Predict function for \code{ps2DNormal}}
\usage{
\method{predict}{ps2dnormal}(object, ..., XY)
}
\arguments{
\item{object}{an object using ps2DNormal.}

\item{...}{other parameters.}

\item{XY}{a matrix of arbitrary (\code{x}, \code{y}) locations for
desired prediction.}
}
\value{
\item{pred}{the estimated mean at (\code{x}, \code{y}) locations, in \code{XY}.}
}
\description{
Prediction function which returns linear
 predictions at arbitrary (x, y) data locations (using \code{ps2DNormal}
 with \code{class ps2dnormal}).
}
\examples{
library(fields)
library(spam)
library(JOPS)

# Get the data
data(ethanol)
x <- ethanol$C
y <- ethanol$E
z <- ethanol$NOx

# Set parameters for domain
xlo <- 7
xhi <- 19
ylo <- 0.5
yhi <- 1.25

# Set P-spline parameters, fit and compute surface
xpars <- c(xlo, xhi, 10, 3, 0.01, 1)
ypars <- c(ylo, yhi, 10, 3, 0.1, 1)
Pars1 <- rbind(xpars, ypars)
fit <- ps2DNormal(cbind(x, y, z), Pars = Pars1)
predict(fit, XY = cbind(x, y)[1:5, ])
}
\references{
Eilers, P.H.C., Marx, B.D., and Durban, M. (2015).
Twenty years of P-splines, \emph{SORT}, 39(2): 149-186.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
