% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KHQ5DFreq.R
\name{KHQ5DFreq}
\alias{KHQ5DFreq}
\title{Cumulative frequency analysis}
\usage{
KHQ5DFreq(
  scores,
  save.xlsx = FALSE,
  filename = NULL,
  sheetName = NULL,
  ignore.invalid = FALSE
)
}
\arguments{
\item{scores}{data.frame with colnames RL, PL, SL, E, and S representing
Role limitation, Physical limitation, Social Limitation, Emotions
and Sleep. Alternatively a data.frame with the KHQ5D health profiles can be
provided in a five digit format e.g., data.frame(state = c(11111, 22432,
34241, 43332)).}

\item{save.xlsx}{logical to indicate whether or not save the results; Default: FALSE.}

\item{filename}{string specifying the file name if save.xlsx = TRUE;
Default: "Res_KHQ5D_Frequency.xlsx".}

\item{sheetName}{string specifying the sheet name if save.xlsx = TRUE;
Default: "Frequency".}

\item{ignore.invalid}{logical to indicate whether to ignore items data
with invalid, incomplete or missing data; Default: FALSE.}
}
\value{
A data frame with the Health states, Frequency, Percentage, Cumulative
frequency and Cumulative percentage for each five digit profile in an KHQ5D
dataset.
}
\description{
Function used to calculate the frequency, percentage, cumulative
frequency and cumulative percentage for each health profile in an KHQ5D dataset
}
\details{
Named vector RL, PL, SL, E and S represent Role limitation,
Physical limitation, Social Limitation, Emotions and Sleep, respectfully.
}
\examples{
scores.df <- data.frame(
  RL = c(1,2,3,4,2), 
  PL = c(4,3,4,3,2), 
  SL = c(1,2,2,4,1), 
  E = c(1,3,4,3,4), 
  S = c(1,2,1,2,1))

KHQ5DFreq(scores = scores.df, ignore.invalid = TRUE)

scores.df2 <- data.frame(state = c(11111, 22432, 34241, 43332, 22141))

KHQ5DFreq(scores = scores.df2, ignore.invalid = TRUE)

KHQ5DFreq(scores = scores.df2$state, ignore.invalid = TRUE)

KHQ5DFreq(scores = c(11111,11111,22432, 34241, 43332, 22141), 
  ignore.invalid = TRUE)

KHQ5DFreq(scores = KHQ5D_data, ignore.invalid = TRUE)

KHQ5DFreq(scores = scores.df, save.xlsx = FALSE, 
  filename = "Res_KHQ5D_Frequency.xlsx", 
  sheetName = "Frequency", 
  ignore.invalid = TRUE)

}
\seealso{
\code{\link[KHQ]{KHQConvKHQ5D}} and \code{\link[KHQ]{KHQ5D}}
}
