% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KcopClust.R
\name{KcopClust}
\alias{KcopClust}
\title{Nonparametric clustering of multivariate populations with arbitrary sizes}
\usage{
KcopClust(Kdata, dn = 3, paired = FALSE, alpha = 0.05)
}
\arguments{
\item{Kdata}{A list of the K dataframe or matrix}

\item{dn}{Number of copulas coefficients considered}

\item{paired}{A logical indicating whether to consider the datas as paired}

\item{alpha}{The significance level used in our decision rule.}
}
\value{
A list with three elements: the number of identified clusters; 2) the cluster affiliation; 3) the discrepancy matrix.
the numbers in the clusters refer to the population indexes of the data list
}
\description{
This function performs the data driven clustering procedure to cluster K
multivariate populations of arbitrary sizes into N subgroups characterized
by a common dependence structure where the number N of clusters is unknow
and will be automatically chosen by our approach. The method is adapted to
paired population and can be used with panel data. See the paper at the
following arXiv weblink: https://arxiv.org/abs/2211.06338 for further information.
}
\examples{
## simulation of 5 three-dimensional populations of different sizes
Packages <- c("copula","gtools","dplyr", "orthopolynom", "stats")
lapply(Packages, library, character.only = TRUE) # if necessary
set.seed(2022)
dat1<-rCopula(50, copula = gumbelCopula(param=6,dim = 2))
dat2<-rCopula(60, copula = claytonCopula(param=0.4,dim = 2))
dat3<-rCopula(55, copula = claytonCopula(param=0.4,dim = 2))
## Form a list of data
Kdata<-list(data1=dat1,data2=dat2,data3=dat3)
## Applying the clustering
KcopClust(Kdata = Kdata)

}
\author{
Yves I. Ngounou Bakam and Denys Pommeret
}
