% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.boundary.kb.R
\name{get.boundary.kb}
\alias{get.boundary.kb}
\title{Dose Escalation or De-escalation Boundaries for Single-agent Trials}
\usage{
get.boundary.kb(
  target,
  ncohort,
  cohortsize,
  marginL = 0.05,
  marginR = 0.05,
  cutoff.eli = 0.95,
  n.earlystop = 100,
  extrasafe = FALSE,
  offset = 0.05
)
}
\arguments{
\item{target}{The target dose-limiting toxicity (DLT) rate.}

\item{ncohort}{The total number of cohorts.}

\item{cohortsize}{The number of patients in the cohort.}

\item{marginL}{The difference between the target and the lower bound of the
"target key" (proper dosing interval) to be defined.\cr
The default is 0.05.}

\item{marginR}{The difference between the target and the upper bound of the
"target key" (proper dosing interval) to be defined.\cr
The default is 0.05.}

\item{cutoff.eli}{The cutoff value to eliminate an overly toxic dose and all
higher doses for safety.\cr
The recommended value is 0.95.}

\item{n.earlystop}{The early stopping parameter. If the number of patients treated at
the current dose reaches \code{n.earlystop}, then stop the trial
and select the MTD based on the observed data. The default
value is 100.}

\item{extrasafe}{Set \code{extrasafe=TRUE} to impose a stricter stopping rule for extra safety, expressed as the stopping boundary value in the result.}

\item{offset}{A small positive number (between 0 and 0.5) to control how strict
the stopping rule is when \code{extrasafe=TRUE}. A larger value leads
to a stricter stopping rule. The default value is 0.05.}
}
\value{
The function returns a matrix, which includes the dose escalation,
  de-escalation, and elimination boundaries.
}
\description{
This function generates the optimal dose escalation or de-escalation boundaries when
conducting a single-agent trial with the Keyboard design.
}
\details{
The Keyboard design relies on the posterior distribution of the toxicity
probability to guide dosage. To make a decision of dose escalation or
de-escalation, given the observed data at the current dose, we first identify an
interval that has the highest posterior probability, referred to as
the "strongest key". This key represents where the true dose-limiting
toxicity (DLT) rate of the current dose is most likely located. If the
strongest key is to the left  of the "target key", then we escalate
the dose because the data suggest that the current
dose is most likely too low; if the strongest key is
to the right of the target key, then we de-escalate the dose
because the observed data suggest that the current dose is likely too high; and
if the strongest key is the target key, then we retain the current dose because
the observed data support the notion that the current dose is most likely to be in the
proper dosing interval.
Graphically, the strongest key is the one with the largest area under the
posterior distribution curve of the DLT rate of the current dose.

\figure{Keyboard.jpg}

An attractive feature of the Keyboard design is that its dose escalation and
de-escalation rules can be tabulated before the onset of the trial. Thus,
when conducting the trial, no calculation or model fitting is needed, and we
 need to count only the number of DLTs observed at the current dose;
the decision to escalate or de-escalate the dose is based on the pre-tabulated
decision rules.

Given all observed data, the Keyboard design uses isotonic regression to obtain an efficient statistical estimate of
the maximum tolerated dose (MTD) by utilizing the fact that toxicity
presumably increases with the dose.

For patient safety, we apply the following Bayesian overdose control rule
after each cohort:
if at least 3 patients have been treated at the given dose and
the observed data indicate that the probability of the current dose's toxicity rate being above the target toxicity rate is more
than 95\%, then we stop the trial to avoid
exposing future patients to these overly toxic doses. The probability
threshold can be specified with \code{cutoff.eli}. When a dose is
eliminated, the design recommends the next lower dose for treating the next cohort of patients. If the lowest dose is overly toxic, then the trial terminates early and no dose is selected as the MTD.
}
\note{
In most clinical applications, the target DLT rate is often a rough
  guess, but finding a dose level with a DLT rate reasonably close to the
  target rate (which ideally would be the MTD) is of interest.
}
\examples{
### Single-agent trial ###

bound <- get.boundary.kb(target=0.3, ncohort=10, cohortsize=3)
print(bound)
}
\references{
Yan F, Mandrekar SJ, Yuan Y. Keyboard: A Novel Bayesian Toxicity Probability
Interval Design for Phase I Clinical Trials.
\emph{Clinical Cancer Research}. 2017; 23:3994-4003.
http://clincancerres.aacrjournals.org/content/23/15/3994.full-text.pdf
}
\seealso{
Other single-agent functions: 
\code{\link{get.oc.kb}()},
\code{\link{select.mtd.kb}()}
}
\concept{single-agent functions}
