% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CV_L2E_TF_lasso.R
\name{CV_L2E_TF_lasso}
\alias{CV_L2E_TF_lasso}
\title{Cross validation for L2E trend filtering regression with Lasso penalization}
\usage{
CV_L2E_TF_lasso(
  y,
  X,
  beta0,
  tau0,
  D,
  lambdaSeq,
  nfolds = 5,
  seed = 1234,
  method = "median",
  max_iter = 100,
  tol = 1e-04,
  trace = TRUE
)
}
\arguments{
\item{y}{Response vector}

\item{X}{Design matrix. Default is the identity matrix.}

\item{beta0}{Initial vector of regression coefficients, can be omitted}

\item{tau0}{Initial precision estimate, can be omitted}

\item{D}{The fusion matrix}

\item{lambdaSeq}{A decreasing sequence of tuning parameter lambda, can be omitted}

\item{nfolds}{The number of cross-validation folds. Default is 5.}

\item{seed}{Users can set the seed of the random number generator to obtain reproducible results.}

\item{method}{Median or mean to calculate the objective value}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Relative tolerance}

\item{trace}{Whether to trace the progress of the cross-validation}
}
\value{
Returns a list object containing the mean and standard error of the cross-validation error -- CVE and CVSE -- for each value of k (vectors),
the index of the lambda with the minimum CVE and the lambda value itself (scalars),
the index of the lambda value with the 1SE CVE and the lambda value itself (scalars),
the sequence of lambda used in the regression (vector), and
a vector listing which fold each element of y was assigned to
}
\description{
\code{CV_L2E_TF_lasso} performs k-fold cross-validation for robust trend filtering regression under the L2 criterion with the Lasso penalty
}
\examples{
## Completes in 30 seconds

set.seed(12345)
n <- 100
x <- 1:n
f <- matrix(rep(c(-2,5,0,-10), each=n/4), ncol=1)
y <- y0 <- f + rnorm(length(f))

## Clean Data
plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
lines(x, f, lwd=3)

D <- myGetDkn(1, n)
lambda <- 10^seq(-1, -2, length.out=20)
# (not run)
# cv <- CV_L2E_TF_lasso(y=y0, D=D, lambdaSeq=lambda, nfolds=2, seed=1234)
# (lambda_min <- cv$lambda.min)

# sol <- L2E_TF_lasso(y=y0, D=D, lambdaSeq=lambda_min)

# plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
# lines(x, f, lwd=3)
# lines(x, sol$Beta, col='blue', lwd=3)

## Contaminated Data
ix <- sample(1:n, 10)
y[ix] <- y0[ix] + 2

plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
lines(x, f, lwd=3)

# (not run)
# cv <- CV_L2E_TF_lasso(y=y, D=D, lambdaSeq=lambda, nfolds=2, seed=1234)
# (lambda_min <- cv$lambda.min)

# sol <- L2E_TF_lasso(y=y, D=D, lambdaSeq=lambda_min)

# plot(x, y, pch=16, cex.lab=1.5, cex.axis=1.5, cex.sub=1.5, col='gray')
# lines(x, f, lwd=3)
# lines(x, sol$Beta, col='blue', lwd=3)

}
