% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{get_GS_MAinf}
\alias{get_GS_MAinf}
\title{Obtain the simulated standardised gap vector}
\usage{
get_GS_MAinf(hdobj)
}
\arguments{
\item{hdobj}{An S3 object of class 'no_nbd' or 'nbd' generated
by \code{\link[=ts_hdchange]{ts_hdchange()}}.}
}
\value{
An array of the simulated counterpart of \eqn{|V_{i}|_{2}^{2}}.
}
\description{
Obtain the simulated standardised gap vector
}
\examples{
# generate data
data_no_nbd <- sim_hdchange_no_nbd(n = 200,
p = 30,
S = 30,
tau = c(40, 100, 160),
dist_info =
  list(dist = "normal", dependence = "MA_inf", param = 1),
jump_max = c(2, 2, 1.5))

# construct no_nbd object
ts_no_nbd <- ts_hdchange(data_no_nbd,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1))

GS_MAinf <- get_GS_MAinf(ts_no_nbd)

}
\references{
Li, J., Chen, L., Wang, W. and Wu, W.B., 2022. \eqn{\ell^2} Inference for Change Points in High-Dimensional Time Series via a Two-Way MOSUM.
\emph{arXiv preprint arXiv:2208.13074}.
}
