% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_preprocessing.R
\name{extract_entities_workflow}
\alias{extract_entities_workflow}
\title{Extract entities from text with improved efficiency using only base R}
\usage{
extract_entities_workflow(
  text_data,
  text_column = "abstract",
  entity_types = c("disease", "drug", "gene"),
  dictionary_sources = c("local", "mesh", "umls"),
  additional_mesh_queries = NULL,
  sanitize = TRUE,
  api_key = NULL,
  custom_dictionary = NULL,
  max_terms_per_type = 200,
  verbose = TRUE,
  batch_size = 500,
  parallel = FALSE,
  num_cores = 2,
  cache_dictionaries = TRUE
)
}
\arguments{
\item{text_data}{A data frame containing article text data.}

\item{text_column}{Name of the column containing text to process.}

\item{entity_types}{Character vector of entity types to include.}

\item{dictionary_sources}{Character vector of sources for entity dictionaries.}

\item{additional_mesh_queries}{Named list of additional MeSH queries.}

\item{sanitize}{Logical. If TRUE, sanitizes dictionaries before extraction.}

\item{api_key}{API key for UMLS access (if "umls" is in dictionary_sources).}

\item{custom_dictionary}{A data frame containing custom dictionary entries to
incorporate into the entity extraction process.}

\item{max_terms_per_type}{Maximum number of terms to fetch per entity type. Default is 200.}

\item{verbose}{Logical. If TRUE, prints detailed progress information.}

\item{batch_size}{Number of documents to process in a single batch. Default is 500.}

\item{parallel}{Logical. If TRUE, uses parallel processing when available. Default is FALSE.}

\item{num_cores}{Number of cores to use for parallel processing. Default is 2.}

\item{cache_dictionaries}{Logical. If TRUE, caches dictionaries for faster reuse. Default is TRUE.}
}
\value{
A data frame with extracted entities, their types, and positions.
}
\description{
This function provides a complete workflow for extracting entities from text
using dictionaries from multiple sources, with improved performance and robust error handling.
}
