% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TS.R
\name{check_formula}
\alias{check_formula}
\title{Check that a formula is proper}
\usage{
check_formula(data, formula)
}
\arguments{
\item{data}{\code{data.frame} including [1] the time variable (indicated 
in \code{timename}), [2] the predictor variables (required by
\code{formula}) and [3], the multinomial response variable (indicated in
\code{formula}) as verified by \code{\link{check_timename}} and 
\code{\link{check_formula}}. Note that the response variables should be
formatted as a \code{data.frame} object named as indicated by the 
\code{response} entry in the \code{control} list, such as \code{gamma} 
for a standard TS analysis on LDA output.}

\item{formula}{\code{formula} to evaluate.}
}
\value{
An error message is thrown if \code{formula} is not proper,
  else \code{NULL}.
}
\description{
Check that \code{formula} is actually a 
  \code{\link[stats]{formula}} and that the
  response and predictor variables are all included in \code{data}.
}
\examples{
  data(rodents)
  document_term_table <- rodents$document_term_table
  document_covariate_table <- rodents$document_covariate_table
  LDA_models <- LDA_set(document_term_table, topics = 2)[[1]]
  data <- document_covariate_table
  data$gamma <- LDA_models@gamma
  check_formula(data, gamma ~ 1)

}
