% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chandrasekaran.R
\name{chandrasekaran_III}
\alias{chandrasekaran_III}
\title{Chandrasekaran III decomposition}
\usage{
chandrasekaran_III(
  mx1,
  mx2,
  age = (1:length(mx1)) - 1,
  nx = rep(1, length(mx1)),
  sex1 = "t",
  sex2 = sex1,
  closeout = TRUE
)
}
\arguments{
\item{mx1}{numeric vector of the mortality rates (central death rates) for population 1}

\item{mx2}{numeric vector of the mortality rates (central death rates) for population 2}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex1}{character either the sex for population 1: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{sex2}{character either the sex for population 2: Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"}) assumed same as \code{sex1} unless otherwise specified.}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
Numeric vector of contributions by age group that sum to the total difference
in life expectancy between the two mortality schedules.
}
\description{
Implements the Chandrasekaran III decomposition as described in Ponnapalli (2005), which combines multiple directional effects into a symmetric average. The method constructs a decomposition of the difference in life expectancy into four parts: the main effect, the operative effect, their average (exclusive effect), and a non-linear interaction term. These are calculated based on life table values.
Let \eqn{e_x^i} denote remaining life expectancy at age \eqn{x} for population \eqn{i}, and \eqn{l_x^i} the number of survivors to age \eqn{x}. Then:
\itemize{
\item \strong{Main effect}:
\deqn{
\frac{l_x^1}{l_x^2} \left[ l_x^2 (e_x^2 - e_x^1) - l_{x+n}^2 (e_{x+n}^2 - e_{x+n}^1) \right]
}
\item \strong{Operative effect}:
\deqn{
\frac{l_x^2}{l_x^1} \left[ l_x^1 (e_x^2 - e_x^1) - l_{x+n}^1 (e_{x+n}^2 - e_{x+n}^1) \right]
}
\item \strong{Exclusive effect}:
\deqn{
\frac{\text{Main effect} + \text{Operative effect}}{2}
}
\item \strong{Interaction effect}:
\deqn{
(e_{x+n}^2 - e_{x+n}^1) \cdot \frac{1}{2} \left[
\frac{l_x^1 \cdot l_{x+n}^2}{l_x^2} + \frac{l_x^2 \cdot l_{x+n}^1}{l_x^1}
- (l_{x+n}^1 + l_{x+n}^2)
\right]
}
}

The final contribution by age group is the sum of exclusive and interaction effects.
}
\details{
This decomposition gives numerically identical results to \code{arriaga_sym()}, \code{lopez_ruzicka_sym()}, and \code{chandrasekaran_II()}, despite conceptual differences in their derivation. Included here for methodological completeness.
}
\examples{
a <- 0.001
b <- 0.07
x <- 0:100
mx1 <- a * exp(x * b)
mx2 <- a/2 * exp(x * b)
cc <- chandrasekaran_III(mx1, mx2, age = x)
e01 <- mx_to_e0(mx1, age = x)
e02 <- mx_to_e0(mx2, age = x)
(delta <- e02 - e01)
sum(cc)
\donttest{
plot(x, cc, type = "l")
}
}
\references{
\insertRef{Ponnapalli2005}{LEdecomp}
}
\seealso{
\code{\link{chandrasekaran_II}}, \code{\link{arriaga_sym}}, \code{\link{lopez_ruzicka_sym}}
}
