% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_skeleton.R
\name{model_skeleton}
\alias{model_skeleton}
\title{Convert a model to a skeleton}
\usage{
model_skeleton(mod, data = NULL, ncont = 3, nfirstcont = 50)
}
\arguments{
\item{mod}{A fitted model \strong{or} a tilde expression describing a model structure, e.g. \code{outcome ~ vara+varb}.}

\item{data}{a data frame. Relevant only when \code{mod} is a tilde expression}

\item{ncont}{minimum number of levels at which to represent continuous variables. (More levels
may be added to "prettify" the choices. See \code{\link[=pretty]{pretty()}}.)}

\item{nfirstcont}{Like \code{ncont}, but for the first explanatory variable if it is categorical. This variable is mapped
to the horizontal axis and so should have many levels to produce a smooth graph. (Default: 50)}
}
\value{
a data frame
}
\description{
A "skeleton" is a data frame containing "nicely spaced" values for the explanatory variables
in a model.
}
\examples{
Model <- CRDS |> model_train(FEV ~ sex + age + height)
Model |> model_skeleton()
}
