% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSVAR.R
\name{fista.LpS}
\alias{fista.LpS}
\title{A function to solve low rank plus sparse model estimation using FISTA algorithm}
\usage{
fista.LpS(
  data,
  lambda,
  mu,
  alpha_L = 0.25,
  niter = 100,
  backtracking = TRUE,
  x.true = NULL
)
}
\arguments{
\item{data}{A numeric dataset with size of n by p}

\item{lambda}{A positive numeric value, indicating the tuning parameter for sparse component}

\item{mu}{A positive numeric value, indicating the tuning parameter for low rank component}

\item{alpha_L}{The constraint coefficient of low rank component, default is 0.25}

\item{niter}{The maximum number of iterations required for FISTA}

\item{backtracking}{A boolean argument, indicating that use backtracking in the FISTA}

\item{x.true}{A p by p matrix, the true model parameter. Only available for simulation.}
}
\value{
A S3 object of class \code{LSVAR}, including
\describe{
  \item{est_phi}{estimated model parameter}
  \item{sparse.comp}{Estimated sparse component}
  \item{lr.comp}{Estimated low-rank component}
  \item{obj.val}{Values of objective function}
  \item{rel.err}{Relative errors compared with the true model parameters if available}
}
}
\description{
A function to solve low rank plus sparse model estimation
}
\examples{
n <- 300
p <- 20
try <- testVAR(n, p, struct = "LS", signal = 0.75, rank = 2,
               singular_vals = c(1, 0.8))
data <- as.matrix(try$series)
lambda <- 0.1; mu <- 1
fit <- fista.LpS(data, lambda = lambda, mu = mu, x.true = try$model_param)
summary(fit, threshold = 0.2)
}
