% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Labelling_and_plotting_functions.R
\name{Relation_per_proband_plot}
\alias{Relation_per_proband_plot}
\title{Plot the (Average) Number of Relatives per Proband by Relationship Type}
\usage{
Relation_per_proband_plot(
  labelled_relations,
  proband_vec,
  reported_info = "both"
)
}
\arguments{
\item{labelled_relations}{A tibble or data frame containing pairwise relationship
labels and their associated metadata. Must include the following columns:
\describe{
\item{id1}{Identifier for the first individual (typically the proband).}
\item{id2}{Identifier for the second individual (the relative).}
\item{gen.x, gen.y}{Number of generations separating each individual from their most recent common ancestor.}
\item{k}{Kinship coefficient between the two individuals.}
\item{lab}{Relationship label assigned by \code{\link[=label_relatives]{label_relatives()}}.}
}}

\item{proband_vec}{A vector of identifiers for probands. The function restricts
the analysis to pairs where \code{id1} is included in this vector.}

\item{reported_info}{Chose which information is reported on the figure.
\describe{
\item{total}{shows the total number of relatives of each type across all probands.}
\item{average}{shows the average number of relatives of each type per proband.}
\item{both}{(default) shows both total and average numbers on the plot.}
}}
}
\value{
A \pkg{ggplot2} object showing the (mean) number of relatives per proband for each
relationship type. The plot can be further modified using standard
\pkg{ggplot2} functions (e.g., \code{+ theme()} or \code{+ labs()}).
}
\description{
Produces a structured visualisation of the (average) number of each relationship
type per proband, based on the labelled pairwise relationship data from
\code{\link[=label_relatives]{label_relatives()}}. The plot arranges relationship types according to
generational distance and degree of relatedness, providing an intuitive overview
of kinship structure within the study sample.
}
\details{
If any relationship types in the input are not recognised in the predefined
mapping (e.g., rare or complex kinships), these are aggregated and shown as
\code{"Other"}.
}
\examples{
# see vignette on identifying and labelling relatives

}
\seealso{
\code{\link[=label_relatives]{label_relatives()}} for generating the relationship labels used as input.
}
