% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mean.test.R
\name{Mean.test}
\alias{Mean.test}
\title{One Sample Mean Test of a Normal Population}
\usage{
Mean.test(x, mu0, sigma = NULL, sc = NULL, s = NULL, n = NULL,
  alternative = "two.sided", alpha = 0.05, plot = TRUE, lwd = 1)
}
\arguments{
\item{x}{a numeric vector of data values or, if single number, estimated mean.}

\item{mu0}{a single number corresponding with the mean to test.}

\item{sigma}{population standard deviation. Defaults to NULL, if specified, a t-test with
known variance will be performed.}

\item{sc}{cuasi-standard deviation of sample x. By default computes the cuasi-standard deviation of argument x.}

\item{s}{sample standard deviation of sample x. Defaults to NULL, if provided, it computes
the cuasi-standard deviation.}

\item{n}{sample size. By default length of argument x.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
"\code{two.sided}" (default), "\code{greater}" or "\code{less}".}

\item{alpha}{a single number in (0,1), significance level.}

\item{plot}{a logical value indicating whether to display a graph including the test statistic value for the sample, its distribution, the rejection region and p-value.}

\item{lwd}{single number indicating the line width of the plot.}
}
\value{
A list with class "\code{lstest}" and "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{parameter}{the degrees of freedom of the statistic's distribution. NULL for the Normal distribution.}
\item{p.value}{the p-value of the test.}
\item{estimate}{the sample mean.}
\item{null.value}{the value specified by the null.}
\item{alternative}{a character string describing the alternative.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string giving the names of the data.}
\item{alpha}{the significance level.}
\item{dist.name}{a character string indicating the distribution of the test statistic.}
\item{statformula}{a character string with the statistic's formula.}
\item{reject.region}{a character string with the reject region.}
\item{unit}{a character string with the units.}
}
\description{
\code{Mean.test} allows to compute hypothesis tests for a Normal population mean in both scenarios:
known and unknown population variance.
}
\details{
The formula interface is applicable when the user provides the sample and also when the user provides the value of the sample characteristics (sample mean, cuasi-standard deviation or sample standard deviation, jointly with the sample size).
}
\examples{
x <- rnorm(50, mean = 4, sd = 2)
#unknown sigma
Mean.test(x, mu0 = 3.5)
Mean.test(mean(x), sc = sd(x),  n = length(x), mu0 = 3.5)
#known sigma
Mean.test(x, mu0 = 3.5, sigma = 2)
}
