% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffmean.test.R
\name{diffmean.test}
\alias{diffmean.test}
\title{Two Sample Mean Test of Normal Populations}
\usage{
diffmean.test(x1, x2, sigma1 = NULL, sigma2 = NULL, sc1 = NULL,
  sc2 = NULL, s1 = NULL, s2 = NULL, n1 = NULL, n2 = NULL,
  var.equal = FALSE, paired = FALSE, alternative = "two.sided",
  alpha = 0.05, plot = TRUE, lwd = 1)
}
\arguments{
\item{x1}{a numeric vector of data values or, if single number, estimated mean.}

\item{x2}{a numeric vector of data values or, if single number, estimated mean.}

\item{sigma1}{if known, a single numeric value corresponding with one of the population standard deviation.}

\item{sigma2}{if known, a single numeric value corresponding with the other population standard deviation.}

\item{sc1}{cuasi-standard deviation of sample x1. By default computes the cuasi-standard deviation of argument \code{x1}.}

\item{sc2}{cuasi-standard deviation of sample x2. By default computes the cuasi-standard deviation of argument \code{x2}.}

\item{s1}{sample standard deviation of sample x1. Defaults to NULL, if provided, it computes
the cuasi-standard deviation.}

\item{s2}{sample standard deviation of sample x2. Defaults to NULL, if provided, it computes
the cuasi-standard deviation.}

\item{n1}{sample size of \code{x1}. By default length of argument \code{x1}.}

\item{n2}{sample size of \code{x2}. By default length of argument \code{x2}.}

\item{var.equal}{a logical indicating whether to treat the two variances as being equal. Defaults to FALSE.}

\item{paired}{a logical indicating whether the samples are paired. Defaults to FALSE, if TRUE,
then both x1 and x2 must be the same length.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
"\code{two.sided}" (default), "\code{greater}" or "\code{less}".}

\item{alpha}{single number in (0,1), corresponding with the significance level.}

\item{plot}{a logical value indicating whether to display a graph including the test statistic value for the sample, its distribution, the rejection region and p-value.}

\item{lwd}{single number indicating the line width of the plot.}
}
\value{
A list with class "\code{lstest}" and "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{parameter}{the degrees of freedom of the statistic's distribution. NULL for the Normal distribution.}
\item{p.value}{the p-value of the test.}
\item{estimate}{the estimated difference in means.}
\item{null.value}{the value specified by the null.}
\item{alternative}{a character string describing the alternative.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string giving the names of the data.}
\item{alpha}{the significance level.}
\item{dist.name}{a character string indicating the distribution of the test statistic.}
\item{statformula}{a character string with the statistic's formula.}
\item{reject.region}{a character string with the reject region.}
}
\description{
\code{diffmean.test} allows to compute hypothesis tests about two population means. The difference between the
means of two Normal populations is tested in different scenarios: known or unknown variance,
variances assumed equal or different and paired or independent populations.
}
\details{
If sigma1 and sigma2 are given, known population variances formula is applied; the unknown one is used in other case.

If paired is TRUE then both x1 and x2 must be specified and their sample sizes must be the same. If paired is null, then it is assumed to be FALSE.

For var.equal=TRUE, the formula of the pooled variance is \eqn{\frac{(n1-1)sc1^2+(n2-1)sc2^2}{n1+n2-2}}.
}
\examples{
x1 <- rnorm(40, mean = 1.5, sd = 2)
x2 <- rnorm(60, mean = 2, sd = 2)
#equal variances
diffmean.test(x1, x2, var.equal = TRUE)
diffmean.test(mean(x1), mean(x2),
              sc1 = sd(x1), sc2 = sd(x2),
              n1 = 40, n2 = 60, var.equal = TRUE)
x3 <- rnorm(60, mean = 2, sd = 1.5)
#different variances
diffmean.test(x1, x3)
#known standard deviation
diffmean.test(x1, x3, sigma1 = 2, sigma2 = 1.5)
x4 <- x1 + rnorm(40, mean = 0, sd = 0.1)
#paired samples
diffmean.test(x1, x4, paired = TRUE)
}
