% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dunif.R
\name{plotDUnif}
\alias{plotDUnif}
\title{Probability Mass and/or Distribution Function Representations associated with a Discrete Uniform Distribution}
\usage{
plotDUnif(x, type = "b", col = "grey")
}
\arguments{
\item{x}{support of the discrete variable.}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for probability mass function and distribution function representations together,
"d" for distribution function representation and "p" for probability mass function representation.}

\item{col}{a single colour associated with the probability mass function representation; default to "grey".}
}
\value{
A matrix containing the probability mass and the distribution function associated with each point
of the support (denoted by \code{x}) of a Discrete Uniform distribution.
}
\description{
\code{plotDUnif} represents the probability mass and/or the distribution function associated with a Discrete Uniform
 distribution with support \code{x}.
}
\examples{
x=1:5
plotDUnif(x,type="d")
plotDUnif(x,type="p",col="pink")
plotDUnif(x)
}
