% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikertEZ.R
\name{plot_item}
\alias{plot_item}
\title{Barplot with RII annotation}
\usage{
plot_item(responses, max_scale = 5, scale_labels = NULL)
}
\arguments{
\item{responses}{Numeric vector of ordinal responses.}

\item{max_scale}{Max Likert scale value (default: 5).}

\item{scale_labels}{Optional vector of labels for each scale point.}
}
\value{
A ggplot2 bar plot with RII annotation.
}
\description{
This function generates a barplot showing the distribution of responses for a single item, with the Relative Importance Index (RII) annotated.
}
\examples{
responses <- c(1, 2, 3, 4, 5, 3, 2, 1, NA)
plot_item(responses)
}
